<?php
/**
 * @version		6.2.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.tabulizer.com
 * 
 */


// no direct access
defined('_JEXEC') or die('Restricted access');

class TabulizerModifyUsercustomfields {
    function modify(&$rows, $args = null) {
		$db = JFactory::getDbo();						
		
        if (empty($rows)) {
            return;
        }
        $num_of_rows = count($rows);
        $num_of_columns = count($rows[1]);			
		
		$candidate_custom_fields = array();
		$custom_fields = array();
		$custom_fields_values = array();		
        
		if (empty($args)) {			
			return;
		} else {			
			$parts = explode(':',$args,4);			
			if (count($parts)!=4) {
				return;				
			} else {	
				$key_id = intval($parts[0]);
				$header_row_id = intval($parts[1]);
				$fields_lang = trim($parts[2]);				
				$column_fields = explode(',',trim($parts[3]));
				foreach ($column_fields as $column_field) {
					list($column_id,$field_ids) = explode('=',$column_field,2);
					$candidate_custom_fields[$column_id] = explode('|',$field_ids);
				}
			}			
		}	
		if (empty($candidate_custom_fields))return;	 
		
		if (($fields_lang == '')||($fields_lang=='all')) {
			$query = 'SELECT * FROM `#__fields`';
		} else if ($fields_lang=='*') {
			$query = 'SELECT * FROM `#__fields` WHERE `language` = '.$db->quote('*');	
		} else {
			if ($fields_lang == 'current') {
				$lang = JFactory::getLanguage();				
				$fields_lang = $lang->getTag(); // returns 'en-GB' or 'en-US' for example
			}
			$query = 'SELECT * FROM `#__fields` WHERE (`language` = '.$db->quote('*').') OR (`language` = '.$db->quote($fields_lang).')';	
		}		
		$db->setQuery($query);
		$allowed_fields_list = $db->loadObjectList();
		if (empty($allowed_fields_list)) return;
		foreach ($allowed_fields_list as $entry) {
			$field_id = intval($entry->id);
			$allowed_field_ids[$field_id] = empty($entry->label)?$entry->title:$entry->label;
		}				
		
		// clean custom fields based on the allowed fields ids
		foreach ($candidate_custom_fields as $column_id => $field_ids) {
			foreach ($field_ids as $field_id) {
				if (isset($allowed_field_ids[$field_id])) {
					$custom_fields[$column_id] = intval($field_id);
					break;
				}
			}
		}
		if (empty($custom_fields)) return;			
				
		$query = 'SELECT * FROM `#__fields_values` WHERE 1';
		$db->setQuery($query);
		$field_values = $db->loadObjectList();
		if (!empty($field_values)) {
			foreach ($field_values as $entry) {
				$item_id = intval($entry->item_id);				
				$field_id = intval($entry->field_id);
				if (isset($allowed_field_ids[$field_id])) {					
					if (!isset($custom_fields_values[$item_id])) $custom_fields_values[$item_id] = array();
					$custom_fields_values[$item_id][$field_id] = $entry->value;				 
				}				
			}
		}				
		
		$modified_rows = array();
		$m_row_id = 0;
		
		foreach ($rows as $row_id => &$row) {
			$m_row_id++;
			$m_column_id = 0;
			if ($row_id == $header_row_id) {				
				foreach ($row as $column_id => &$cell) {
					$m_column_id++;
					if (isset($custom_fields[$m_column_id])) {
						$field_id = $custom_fields[$m_column_id];
						$modified_rows[$m_row_id][$m_column_id] = $allowed_field_ids[$field_id];
						$m_column_id++;
					}
					$modified_rows[$m_row_id][$m_column_id] = $cell;										
				}
			} else {
				foreach ($row as $column_id => &$cell) {						
					$m_column_id++;
					if (isset($custom_fields[$m_column_id])) {
						$field_id = $custom_fields[$m_column_id];
						$asset_id = intval($row[$key_id]);						
						if (isset($custom_fields_values[$asset_id])) {
							if (isset($custom_fields_values[$asset_id][$field_id])) {
								$modified_rows[$m_row_id][$m_column_id] = $custom_fields_values[$asset_id][$field_id];	
								$m_column_id++;
							}
						}
					}
					$modified_rows[$m_row_id][$m_column_id] = $cell;
				}
			}
		}
				
		$rows = $modified_rows;
				
    }
}
?>
