<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

class TabulizerModifyRowcount extends TabulizerModify {
    function modify(&$rows, $args = null) {
        if (empty($rows)) {
            return;
        }
		
		$num_of_rows = count($rows);
		$num_of_columns = count($rows[1]);
        
        if (empty($args)) return;
		$parts = explode(',',$args);
		$header_rows_count = (isset($parts[0]))?intval($parts[0]):0;
		$bottom_rows_count = (isset($parts[1]))?intval($parts[1]):0;
		$column_count_id = (isset($parts[2]))?intval($parts[2]):1;
		$count_prefix_str = (isset($parts[3]))?$parts[3]:'';
		$count_suffix_str = (isset($parts[4]))?$parts[4]:'';
		
		$bottom_rows_count = $num_of_rows - $bottom_rows_count;
		
		$row_count = 0;
		
		$modified_rows = array();
        for ($i=1;$i<=$num_of_rows;$i++) {
			$row = $rows[$i];
			$modified_row = array();
			$k=0;
			if (($i<=$header_rows_count)||($i>$bottom_rows_count)) {
				for ($j=1;$j<=$num_of_columns;$j++) {
					if ($j==$column_count_id) {
						$k++;
						$modified_row[$k] = '';						
					} 
					$k++;
					$modified_row[$k] = $row[$j];
				}
			} else {
				for ($j=1;$j<=$num_of_columns;$j++) {
					if ($j==$column_count_id) {
						$k++;
						$row_count++;
						$modified_row[$k] = $count_prefix_str . $row_count . $count_suffix_str;						
					} 
					$k++;
					$modified_row[$k] = $row[$j];
				}
			}
			$modified_rows[$i] = $modified_row;            
        }
        $rows = $modified_rows;		
    }
}
?>