<?php

class TabulizerModifyColumnmerge {

  function expParser($str) {
      $parts = array();
      $part = '';
      $escaped = false;
      $assign = false;
      $len = mb_strlen($str, 'UTF-8');    
      for ($i=0;$i<$len;$i++) {
          $chr = mb_substr($str,$i,1,'UTF-8');
          switch($chr) {
              case '+': 
                  if (!$escaped) {
                      if ($part!='') $parts[] = array('value'=>intval($part), 'type'=>'column');
                      $part = '';
                  }
                  break;
              case '=':
                  if (!$escaped) {
                      if ($part!='') $parts[] = array('value'=>intval($part), 'type'=>'column');
                      $part = '';
                      $assign = true;
                  }
                  break;            
              case '"': 
                  if ($escaped) {
                      $escaped = false;
                      if ($part!='') $parts[] = array('value'=>$part, 'type'=>'string');
                      $part = '';
                  } 
                  else $escaped = true; 
                  break;
              default:
                  $part .= $chr;
          }
      }
      if ($assign && ($part!='') && (!empty($parts))) {
          $expression = array('operands' => $parts, 'assigned' => intval($part));
          return $expression;
      } else return null;
  }

  function modify(&$rows, $args = null) {    
     if (empty($rows)) return;
     $num_of_rows = count($rows);
     $num_of_columns = count($rows[1]);          
     
     if (empty($args)) return;
     $merging_expression = $this->expParser(trim($args));
     if (empty($merging_expression)) return;          
     
     for ($row_id=1;$row_id<=$num_of_rows;$row_id++) {
        $value = '';                 
        foreach ($merging_expression['operands'] as $operand) {
          if ($operand['type'] == 'column') {
             if (isset($rows[$row_id][$operand['value']])) {
                $value .= $rows[$row_id][$operand['value']];
             } 
          } else if ($operand['type'] == 'string') {
              $value .= $operand['value'];
          }
        }
        if (isset($rows[$row_id][$merging_expression['assigned']])) {
          $rows[$row_id][$merging_expression['assigned']] = $value;
        }                    
     }                   
     
  }
  
}     

?>
