<?php
class TabulizerModifyFilterbyparam extends TabulizerModify {
		
    function modify(&$rows, $args = null) {
        if (empty($rows)) return;
			
        $num_of_rows = count($rows);
        $num_of_columns = count($rows[1]);      		
        
		list($filter_key, $filter_pos, $top_header, $bottom_header) = explode(',',trim(strtolower($args),4));				
		
		$top_header = intval($top_header);
		$bottom_header = $num_of_rows + 1 - intval($bottom_header);
		$filter_pos = intval($filter_pos);
						
		if (($num_of_columns < $filter_pos)||($filter_pos<1)) {
			echo "The filter position $filter_pos is outside of the available columns!";
			return false;
		}
		
		$filter_value = $this->param($filter_key);						
						
		if ($filter_value != 'admin') {
			$filter_rows = array();
			$filter_row_id = 0;
			for ($i=1;$i<=$num_of_rows;$i++) {            
				if (($i<=$top_header)||($i>=$bottom_header)) {
					$filter_row_id++;
					$filter_rows[$filter_row_id] = $rows[$i];		
				} else {
					$value = $rows[$i][$filter_pos];																	
					if ($value == $filter_value) {
						$filter_row_id++;
						$filter_rows[$filter_row_id] = $rows[$i];
					}	
				}												                            
			}
			$rows = $filter_rows;
		}
						        						
		   
    }
}
?>